<?php

// adds page in admin section
require_once dirname ( __FILE__ ) . '/mailbox_micro_formats_form.php';

add_action ( 'admin_menu', 'mailbox_micro_formats_setform' );
function mailbox_micro_formats_setform() {
	add_submenu_page ( 'options-general.php', get_option ( "MAILBOX_MICRO_FORMATS_NAME" ), get_option ( "MAILBOX_MICRO_FORMATS_NAME" ), 'manage_options', 'mailbox_micro_formats_form', 'mailbox_micro_formats_updateform' ); // sets and adds the form to the admin section
}

// management of plugin data & general settings
add_action ( 'admin_init', 'mailbox_micro_format_admin_init' );
function mailbox_micro_format_admin_init() {
	// settings
	register_setting ( 'mailbox_micro_formats', 'organization' );
	register_setting ( 'mailbox_micro_formats', 'url' );
	register_setting ( 'mailbox_micro_formats', 'email' );
	register_setting ( 'mailbox_micro_formats', 'telephone' );
	register_setting ( 'mailbox_micro_formats', 'logo' );
	register_setting ( 'mailbox_micro_formats', 'vat' );
	register_setting ( 'mailbox_micro_formats', 'street' );
	register_setting ( 'mailbox_micro_formats', 'zip' );
	register_setting ( 'mailbox_micro_formats', 'locality' );
	register_setting ( 'mailbox_micro_formats', 'country' );
	register_setting ( 'mailbox_micro_formats', 'description' );
	register_setting ( 'mailbox_micro_formats', 'add_bio' );
	register_setting ( 'mailbox_micro_formats', 'kml_map' );
	register_setting ( 'mailbox_micro_formats', 'add_bio' );
	register_setting ( 'mailbox_micro_formats', 'show_button' ); //show the button on the post editor y/n

	// allow shortcode in widgets, contact form7
	add_filter ( 'widget_text', 'do_shortcode' );
	add_filter ( 'wpcf7_form_elements', 'do_shortcode' );

	// opening hours
	register_setting ( 'mailbox_micro_formats', 'mailbox_micro_formats_opening_hours' );
	register_setting ( 'mailbox_micro_formats', 'mailbox_micro_formats_include_weekend' );
	register_setting ( 'mailbox_micro_formats', 'monday' );
	register_setting ( 'mailbox_micro_formats', 'tuesday' );
	register_setting ( 'mailbox_micro_formats', 'wednesday' );
	register_setting ( 'mailbox_micro_formats', 'thursday' );
	register_setting ( 'mailbox_micro_formats', 'friday' );
	register_setting ( 'mailbox_micro_formats', 'saturday' );
	register_setting ( 'mailbox_micro_formats', 'sunday' );

	// add shortcodes above editor
}

if (get_option( 'show_button' ) =="1"){
$popup = new mailbox_micro_format_shortcode_popup ();
$popup->run();
}

class mailbox_micro_format_shortcode_popup {
	// http://www.sitepoint.com/adding-a-media-button-to-the-content-editor/
	public function __construct() {
	}
	public function run() {
		$this->add_custom_popup();
	}
	public function add_custom_popup() {
		add_action ( 'media_buttons_context', array (
				$this,
				'add_my_custom_button'
		) );
		add_action ( 'admin_footer', array (
				$this,
				'add_inline_popup_content'
		) );
	}
	public function add_my_custom_button($context) {

		// the id of the container I want to show in the popup
		$container_id = 'popup_container';

		// our popup's title
		$title = 'Mailbox Micro Formats';

		// button text
		$text = "Microformats";

		// append the icon
		$context .= "<a class='thickbox button' title='{$title}'href='#TB_inline?width=400&inlineId={$container_id}'>{$text}</a>";

		return $context;
	}
	public function add_inline_popup_content() {
		$sc1 = "[organization name='your company'  vat='123' logo='url' telephone='123' email='x' url='url']company short description[/organization]";
		$sc2 = "[address street='xx' zip='1000' locality='z' country='country' /]";

		$sc1 = str_replace ( "'", "&quot;", $sc1 );
		$sc2 = str_replace ( "'", "&quot;", $sc2 );
		?>
<div id="popup_container" class="popip" style="display: none;z-index=100000;">
	<style>
.wide {
	display: block !important;
	margin-bottom: 20px !important;
}
</style>
	<h2>Mailbox Microformats</h2>
	<button class="button wide"
		onClick="window.parent.send_to_editor('[mycompany]');">[mycompany /]</button>
	<button class="button wide"
		onClick="window.parent.send_to_editor('[myaddress]');">[myaddress /]</button>
	<button class="button wide"
		onClick="window.parent.send_to_editor('[hours]');">[working hours /]</button>
	<button class="button wide"
		onClick="window.parent.send_to_editor('<?php echo $sc1; ?>');">[organization
		name="your company"]company short description[/organization]</button>
	<button class="button wide"
		onClick="window.parent.send_to_editor('<?php echo $sc2; ?>');">[address
		street="xx" zip="1" locality="z" country="country" /]</button>
</div>
<?php
	}
}

// new Shortcode_Tinymce();
class Shortcode_Tinymce {

	// http://www.paulund.co.uk/add-button-tinymce-shortcodes
}








